using System;

public class Shape
{
  public virtual void Draw()
  {
    Console.WriteLine("Jestem jakim ksztatem.");
  }
}

public class Circle : Shape
{
  public override void Draw()
  {
    Console.WriteLine(" ######");
    Console.WriteLine("#      #");
    Console.WriteLine("#      #");
    Console.WriteLine("#      #");
    Console.WriteLine("#      #");
    Console.WriteLine(" ###### ");
  }
}

public class Rectangle : Shape
{
  public override void Draw()
  {
    Console.WriteLine("##############");
    Console.WriteLine("#            #");
    Console.WriteLine("#            #");
    Console.WriteLine("#            #");
    Console.WriteLine("##############");
  }
}

public class Triangle : Shape
{
  public override void Draw()
  {
    Console.WriteLine("    #");
    Console.WriteLine("   # #");
    Console.WriteLine("  #   #");
    Console.WriteLine(" #     #");
    Console.WriteLine("#########");
  }
}

public class Program
{
  public static void DrawShape(Shape shape)
  {
    shape.Draw();
  }
  public static void Main()
  {
    Circle circle = new Circle();
    Triangle triangle = new Triangle();
    Rectangle rectangle = new Rectangle();

    DrawShape(circle);
    DrawShape(triangle);
    DrawShape(rectangle);
  }
}
